function [C11,C22,C12,G,D,M]=assemblastokes(dcdx,dedx,dcdy,dedy,detjac,gradgrad,...
    vertices,elements,nln_u,nln_p,pl,nov,nov_v,nov_p,noe,DIVX,DIVY,...
    diffusion,rho,l1,l2,MASSA)
% Matrices with viscosity and density piecewise constant.




aloc = [diffusion.*dcdx.^2; ...
           diffusion.*dedx.^2; ...
           diffusion.*dcdx.*dedx; ...
           diffusion.*dedx.*dcdx]'*gradgrad;
   
C11 = sparse(nov,nov);
C22 = sparse(nov,nov);
C12 = sparse(nov,nov);
M = C11; 


for ie = 1:noe   
    i = (elements(1:nln_u,ie))';
    local = [];  
 %   localmassa=[];
    for j = 1:nln_u
        local = [local; aloc(ie,l1(j):l2(j))];
    end
    
   
    C11(i,i) = C11(i,i)+(2*local)*detjac(ie); 
    C22(i,i) = C22(i,i)+(local)*detjac(ie);
    M(i,i) = M(i,i) + MASSA*detjac(ie);
end

%
aloc = [diffusion.*dcdy.^2; ...
        diffusion.*dedy.^2; ...
        diffusion.*dcdy.*dedy; ...
        diffusion.*dedy.*dcdy]'*gradgrad;
for ie = 1:noe   
    i = (elements(1:nln_u,ie))';
    local = [];  
    for j = 1:nln_u
        local = [local; aloc(ie,l1(j):l2(j))];
    end
    C11(i,i) = C11(i,i)+local*detjac(ie); 
    C22(i,i) = C22(i,i)+2*local*detjac(ie); 
end

%
aloc = [diffusion.*dcdx.*dcdy; ...
        diffusion.*dedx.*dedy; ...
        diffusion.*dcdx.*dedy; ...
        diffusion.*dedx.*dcdy]'*gradgrad;
for ie = 1:noe   
    i = (elements(1:nln_u,ie))';
    local = [];  
    for j = 1:nln_u
        local = [local; aloc(ie,l1(j):l2(j))];
    end
    C12(i,i) = C12(i,i)+local*detjac(ie); 
end

%[G]=localgradP1(nln_u,nln_p,pl,nov,nov_v,nov_p,noe,elements,DIVX,DIVY,dcdx,dedx,dcdy,dedy,detjac);
%keyboard
[D]=localdivP0(nln_u,nln_p,pl,nov,nov_v,nov_p,noe,elements,DIVX,DIVY,dcdx,dedx,dcdy,dedy,detjac);
G=D';
%keyboard

return
